"use strict";

describe("StorageModule", function() {

    var dummyModule = null;

    beforeAll(function() {
        jasmine.helpers.dumpStorage();
        jasmine.helpers.clearStorage();
        dummyModule = App.module("DummyModule");
    });

    beforeEach(function() {
        jasmine.helpers.clearStorage();
    });
    
    afterAll(function() {
        jasmine.helpers.restoreStorageFromDump();
    });

    it("works with strings: writes and reads", function() {
        var testVars = [
                ["MyString", "42"],
                ["MyString2", "test"],
        ];
        var faultyVars = [
                ["MyString", 42],
                ["MyString2", {}],
                ["MyString3", [1,2,3]]
                ["MyString4", null]
        ];
        
        for (var i = 0; i < testVars.length; i++) {
            var testVar = testVars[i];
            expect(localStorage.length).toEqual(0);
            expect(App.DataModule.Storage.setStrCache(dummyModule, testVar[0], testVar[1])).toEqual(true);
            expect(localStorage.getItem("dml.DummyModule." + testVar[0])).toEqual(testVar[1]);
            expect(localStorage.length).toEqual(1);
            
            expect(App.DataModule.Storage.setStrCache(dummyModule, testVar[0], undefined)).toEqual(true);
            expect(App.DataModule.Storage.getStrCache(dummyModule, testVar[0])).toEqual(undefined);
            expect(localStorage.getItem("dml.DummyModule." + testVar[0])).toEqual(null);
            expect(localStorage.length).toEqual(0);
        }
        
        for (var i = 0; i < faultyVars.length; i++) {
            var faultyVar = faultyVars[i];
            expect(function() {
                App.DataModule.Storage.setStrCache(dummyModule, faultyVar[0], faultyVar[1]);
            }).toThrow();

            expect(localStorage.length).toEqual(0);
        }
    });

    it("works with strings: returns false when storage is full", function() {
        var storageBecameFull = false;
        var strToWrite = _.str.repeat("x", 100000);
        for (var i = 0; i < 1000; i++) {
            var result = App.DataModule.Storage.setStrCache(dummyModule, "test" + i, strToWrite);
            if (result === true) {
                expect(localStorage.getItem("dml.DummyModule." + "test" + i)).toEqual(strToWrite);
            } else {
                storageBecameFull = true;
                expect(function() {
                    localStorage.setItem("dml.DummyModule." + "test" + i, strToWrite);
                }).toThrow();
                break;
            }
        }
        expect(storageBecameFull).toBe(true);
    });


    it("works with objects: writes and reads", function() {
        var testVars = [
                ["MyString", {}],
                ["MyString", []],
                ["MyString2", null],
                ["MyString3", {x: 2, y: null, z: undefined, a: "string", b: ["array"], c: {object: true}}],
                ["MyString2", [10, 20, 30]]
        ];
        var faultyVars = [
                ["MyString", 42],
                ["MyString3", "test"],
                ["MyString3", "[1, 2, 3"],
                ["MyString3", "{x: 10"],
        ];
        
        for (var i = 0; i < testVars.length; i++) {
            var testVar = testVars[i];
            expect(localStorage.length).toEqual(0);
            expect(App.DataModule.Storage.setObjCache(dummyModule, testVar[0], testVar[1])).toEqual(true);
            expect(localStorage.getItem("dml.DummyModule." + testVar[0])).toEqual(JSON.stringify(testVar[1]));
            expect(localStorage.length).toEqual(1);
            
            expect(App.DataModule.Storage.setObjCache(dummyModule, testVar[0], undefined)).toEqual(true);
            expect(App.DataModule.Storage.getObjCache(dummyModule, testVar[0])).toEqual(undefined);
            expect(localStorage.getItem("dml.DummyModule." + testVar[0])).toEqual(null);
            expect(localStorage.length).toEqual(0);
        }
        for (var i = 0; i < faultyVars.length; i++) {
            var faultyVar = faultyVars[i];
            expect(function() {
                App.DataModule.Storage.setObjCache(dummyModule, faultyVar[0], faultyVar[1]);
            }).toThrow();

            expect(localStorage.length).toEqual(0);
            
            if (_.isString(faultyVar[1])) {
                App.DataModule.Storage.setStrCache(dummyModule, faultyVar[0], faultyVar[1]);
                expect(App.DataModule.Storage.getObjCache(dummyModule, faultyVar[0])).toEqual(null);
                App.DataModule.Storage.setStrCache(dummyModule, faultyVar[0], undefined);
            }

            expect(localStorage.length).toEqual(0);
        }

    });

    
});
